/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class SatCFeController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprimeVenda;
    @FXML
    private Button btnExportar;
    @FXML
    private TableView<SatCFe> tabela;
    @FXML
    private TableColumn<SatCFe, String> colNome;
    @FXML
    private TableColumn<SatCFe, String> colCodigo;
    @FXML
    private TableColumn<SatCFe, String> colCpf;
    @FXML
    private TableColumn<SatCFe, String> colData;
    @FXML
    private TableColumn<SatCFe, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<SatCFe> satCFeList;
    private ControleSAT controleSAT;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.satCFeList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.CupomSAT);
    }

    private void imprimeCupomSAT() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.CANCELAR).booleanValue()) {
            return;
        }
        SatCFe satCFe = (SatCFe)this.tabela.getSelectionModel().getSelectedItem();
        if (satCFe == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma cupom selecionado para impress\u00e3o.");
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])satCFe.getXml().getArquivo(), (Configuracao)this.conf, (SatCFe)satCFe);
        }
        catch (Exception ex) {
            Logger.getLogger(SatCFeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void exportar() {
        ObservableList cupomList = this.tabela.getItems();
        if (cupomList == null || cupomList.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum cupom listado para o filtro informado.");
            return;
        }
        String pathExport = "C:/Maxima/ExportSAT/";
        File pasta = new File(pathExport);
        if (!pasta.exists()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Caminho para exporta\u00e7\u00e3o de arquivos n\u00e3o encontado. ( " + pathExport + " )"));
            return;
        }
        for (SatCFe cupom : cupomList) {
            try {
                SatCFeXml xml = this.satCFeService.loadXml(cupom.getId().longValue());
                String nome = cupom.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + cupom.getHoraEmissao() + "-CFe" + cupom.getChaveAcesso() + ".xml";
                ControleArquivos.escreverBytesArquivo((String)(pathExport + nome), (byte[])xml.getArquivo());
            }
            catch (Exception ex) {
                Logger.getLogger(SatCFeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)("Cupons exportados com sucesso! Destino: " + pathExport));
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("numeroCupom"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colCpf.setCellValueFactory((Callback)new PropertyValueFactory("cpfCnpjDest"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nomeConsumidor"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.satCFeList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.satCFeService.lista(inicio, fim, filtro);
        this.satCFeList.addAll((Collection)list);
        this.tabela.setItems(this.satCFeList);
        BigDecimal total = BigDecimal.ZERO;
        for (SatCFe cupom : this.satCFeList) {
            if (cupom.getCancelado().booleanValue()) continue;
            total = total.add(cupom.getTotal());
        }
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void carregaIcones() {
        this.btnImprimeVenda.setGraphic((Node)new MaximaIcone().getPdf());
    }

    private void registraAcoes() {
        this.btnExportar.setOnAction(evt -> this.exportar());
        this.btnImprimeVenda.setOnAction(event -> this.imprimeCupomSAT());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

