/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.print;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.ESCPrinter;
import br.com.maximasolutions.core.print.TancaPrinter;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.sat.xml.modelo.CFeImpressao;
import br.com.maximasolutions.sat.xml.modelo.DetalhamentoProdutosCFe;
import br.com.maximasolutions.sat.xml.modelo.MP;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SatImpressaoTanca {
    public static void imprimeCupom(byte[] xml, Configuracao conf) throws Exception {
        try {
            String idCFe;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml);
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            Node raiz = raizes.item(0);
            CFeImpressao impressao = new CFeImpressao(raiz);
            String nomeFantasia = impressao.getInfCFe().getEmit().getxFant();
            String razao = impressao.getInfCFe().getEmit().getxNome();
            String CNPJ = MaximaUtils.formatCNPJ((String)impressao.getInfCFe().getEmit().getCNPJ().trim());
            String IE = MaximaUtils.formatIE((String)impressao.getInfCFe().getEmit().getIE());
            String IM = impressao.getInfCFe().getEmit().getIM();
            String logradouro = impressao.getInfCFe().getEmit().getEnderEmit().getxLgr();
            String nro = impressao.getInfCFe().getEmit().getEnderEmit().getNro();
            String bairro = impressao.getInfCFe().getEmit().getEnderEmit().getxBairro();
            String cpl = impressao.getInfCFe().getEmit().getEnderEmit().getxCpl();
            String mun = impressao.getInfCFe().getEmit().getEnderEmit().getxMun();
            String nCFe = impressao.getInfCFe().getIde().getnCFe();
            String vImposto = impressao.getInfCFe().getTotal().getvCFeLei12741();
            String destinatario = MaximaUtils.formatCPF((String)impressao.getInfCFe().getDest().getCPF());
            if (destinatario == null) {
                destinatario = MaximaUtils.formatCNPJ((String)impressao.getInfCFe().getDest().getCNPJ());
            }
            String nomeConsumidor = null;
            if (destinatario != null) {
                nomeConsumidor = impressao.getInfCFe().getDest().getxNome();
            }
            String endereco = "";
            if (logradouro != null) {
                endereco = endereco + logradouro;
            }
            if (nro != null) {
                endereco = endereco + " " + nro;
            }
            if (cpl != null) {
                endereco = endereco + " " + cpl;
            }
            if (bairro != null) {
                endereco = endereco + " " + bairro;
            }
            if (mun != null) {
                endereco = endereco + " " + mun;
            }
            String cabecalho = ESCPrinter.iniciaImpressao();
            if (conf.getNomeEmpresa() != null && !conf.getNomeEmpresa().isEmpty()) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)ESCPrinter.negrita((String)MaximaUtils.removeAcentos((String)conf.getNomeEmpresa().toUpperCase()))) + "\n";
            }
            if (conf.getTelefoneEmpresa() != null && !conf.getTelefoneEmpresa().isEmpty()) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)ESCPrinter.negrita((String)("FONE: " + MaximaUtils.removeAcentos((String)conf.getTelefoneEmpresa().toUpperCase())))) + "\n";
            }
            if (nomeFantasia != null) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)nomeFantasia)) + "\n";
            }
            if (razao != null) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)razao)) + "\n";
            }
            if (endereco.length() > 0) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)endereco)) + "\n";
            }
            cabecalho = cabecalho + "\n";
            if (CNPJ != null) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)("CNPJ " + CNPJ));
            }
            if (IE != null) {
                cabecalho = cabecalho + ESCPrinter.centraliza((String)(" IE " + IE));
            }
            if (IM != null) {
                cabecalho = cabecalho + " IM " + IM;
            }
            cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
            cabecalho = cabecalho + "\n" + ESCPrinter.centraliza((String)ESCPrinter.negrita((String)("Extrato No. " + nCFe)));
            cabecalho = cabecalho + "\n" + ESCPrinter.centraliza((String)ESCPrinter.negrita((String)"CUPOM FISCAL ELETRONICO - SAT"));
            cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
            if (destinatario != null) {
                cabecalho = cabecalho + "\n" + ESCPrinter.alinha_esquerda((String)("CPF/CNPJ do Consumidor: " + destinatario));
                if (nomeConsumidor != null && !nomeConsumidor.isEmpty()) {
                    cabecalho = cabecalho + "\n" + ESCPrinter.alinha_esquerda((String)("Razao Social/Nome: " + nomeConsumidor));
                }
                cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
            }
            cabecalho = cabecalho + "\n#|COD|DESC|QT|UN|VL UN R$|(VL TR R$)*|VL ITEM R$";
            cabecalho = cabecalho + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
            String corpo = "";
            ArrayList produtos = impressao.getInfCFe().getDet();
            for (int i = 0; i < produtos.size(); ++i) {
                String numero = ((DetalhamentoProdutosCFe)produtos.get(i)).getNItem();
                String codigo = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getcProd();
                String descricao = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getxProd();
                String qtd = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getqCom();
                String un = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getuCom();
                String vUn = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getvUnCom();
                String valor = ESCPrinter.alinha_direita((String)((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getvItem());
                String imp = ((DetalhamentoProdutosCFe)produtos.get(i)).getImposto().getvItem12741();
                corpo = corpo + ESCPrinter.alinha_esquerda((String)(numero + " " + (String)codigo + " " + descricao + " " + qtd + " " + un + " X " + vUn + "(" + imp + ") ")) + valor + "\n";
            }
            cabecalho = cabecalho + corpo;
            String total = impressao.getInfCFe().getTotal().getValorCupom();
            String troco = impressao.getInfCFe().getPgto().getvTroco();
            corpo = "";
            corpo = "\n" + ESCPrinter.negrita((String)(MaximaUtils.completaDireita((String)"TOTAL R$", (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)total, (String)" ", (int)28)));
            for (MP pgto : impressao.getInfCFe().getPgto().getMp()) {
                corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)(MaximaUtils.completaDireita((String)MaximaUtils.removeAcentos((String)FormaPagamento.valueOfCodigoSat((String)pgto.getcMP()).toString()), (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)pgto.getvMP(), (String)" ", (int)28)));
            }
            corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)(MaximaUtils.completaDireita((String)"TROCO R$", (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)troco, (String)" ", (int)28)));
            corpo = corpo + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
            corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)"OBSERVACOES DO CONTRIBUINTE");
            if (vImposto != null) {
                corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)("Valor aproximado dos tributos R$: " + vImposto));
            }
            corpo = corpo + "\n* Valor aproximado dos tributos do item";
            corpo = corpo + "\n\n" + impressao.getInfCFe().getInfAdic().getInfCpl();
            String rodape = corpo = corpo + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
            String data = impressao.getInfCFe().getIde().getdEmi();
            String hora = impressao.getInfCFe().getIde().gethEmi();
            String novoidCFe = idCFe = impressao.getInfCFe().getId().substring(3) + " ";
            data = data.substring(6, 8) + "/" + data.substring(4, 6) + "/" + data.substring(0, 4);
            hora = hora.substring(0, 2) + ":" + hora.substring(2, 4) + ":" + hora.substring(4);
            rodape = rodape + "\n" + ESCPrinter.centraliza((String)("SAT No. " + impressao.getInfCFe().getIde().getNserieSAT()));
            rodape = rodape + "\n" + ESCPrinter.centraliza((String)(data + " - " + hora));
            rodape = rodape + "\n\n" + ESCPrinter.centraliza((String)SatImpressaoTanca.inserirChar((int)4, (String)novoidCFe, (String)" "));
            cabecalho = cabecalho + rodape + "\n\n\n";
            String qrcode = SatImpressaoTanca.completarQRCode((CFeImpressao)impressao);
            TancaPrinter printer = new TancaPrinter(conf);
            printer.printText(cabecalho);
            printer.printCodigoBarras(novoidCFe.substring(0, 22));
            printer.printCodigoBarras(novoidCFe.substring(22, 44));
            printer.printQRCode(qrcode);
            printer.printText(ESCPrinter.maximaSoft());
            printer.printText(ESCPrinter.finaliza());
            printer.finaliza();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SatImpressaoTanca.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("Falha na comunica\u00e7\u00e3o com a impressora.\nVerifique se a impressora est\u00e1 ligada e conectada corretamente ao computador.\nCupom fiscal validado com sucesso. Fa\u00e7a a re-impress\u00e3o do cupom fiscal." + ex.getMessage());
        }
    }

    private static String completarQRCode(CFeImpressao cfeImpressao) {
        String chaveConsulta = cfeImpressao.getInfCFe().getId().replace("CFe", "");
        String timestamp = cfeImpressao.getInfCFe().getIde().getdEmi() + cfeImpressao.getInfCFe().getIde().gethEmi();
        String valor = cfeImpressao.getInfCFe().getTotal().getValorCupom();
        String destinatario = cfeImpressao.getInfCFe().getDest().getCPF();
        if (destinatario == null) {
            destinatario = cfeImpressao.getInfCFe().getDest().getCNPJ();
        }
        if (destinatario == null) {
            destinatario = "";
        }
        String assinatura = cfeImpressao.getInfCFe().getIde().getAssinaturaQRCODE();
        System.out.println("ASS.: " + chaveConsulta.length() + "\n" + chaveConsulta);
        return chaveConsulta.replace("CFe", "") + "|" + timestamp + "|" + valor + "|" + destinatario + "|" + assinatura;
    }

    private static String inserirChar(int espaco, String valor, String caracter) {
        int start = 0;
        String novoValor = "";
        while (start + espaco <= valor.length()) {
            if (start == 24) {
                novoValor = novoValor + "\n";
            }
            novoValor = novoValor + valor.substring(start, start + espaco) + caracter;
            start += espaco;
        }
        return novoValor.trim();
    }
}

