/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.repository;

import br.com.maximasolutions.sat.modelo.SatCFeItem;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SatCFeItemRepository
extends JpaRepository<SatCFeItem, Long> {
    @Query(value="SELECT o FROM SatCFeItem o WHERE o.cfe.id = :cupomId ORDER BY o.id")
    public List<SatCFeItem> listaPorCupom(@Param(value="cupomId") Long var1);

    @Query(value="SELECT o.produto.nome, o.quantidade, o.valorUnitario, o.valorTotalItem, o.cfe.dataEmissao, o.cfe.numeroCupom FROM SatCFeItem o WHERE (o.cfe.dataEmissao between :inicio and :fim) ORDER BY o.descricao")
    public List<SatCFeItem> listaPorPeriodo(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Query(value="SELECT o.produto.nome, o.quantidade, o.valorUnitario, o.valorTotalItem, o.cfe.dataEmissao, o.cfe.numeroCupom FROM SatCFeItem o WHERE (o.cfe.dataEmissao between :inicio and :fim) ORDER BY o.descricao")
    public List<Object[]> listaPorPeriodoBean(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Query(value="SELECT o.produto.nome, sum(o.quantidade), avg(o.valorUnitario), sum(o.valorTotalItem), o.cfe.dataEmissao, o.cfe.numeroCupom, o.produto.codigo, o.cson, o.produto.categoriaProduto.nome FROM SatCFeItem o WHERE (o.cfe.dataEmissao between :inicio and :fim) GROUP BY o.produto.id ORDER BY o.produto.categoriaProduto.nome, o.produto.nome ASC")
    public List<Object[]> listaPorPeriodoAgrupado(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);
}

