/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.service;

import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.nfe.relatorio.bean.RelatorioFiscalDto;
import br.com.maximasolutions.nfe.relatorio.bean.RelatorioFiscalProdutoBean;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeItem;
import br.com.maximasolutions.sat.modelo.SatCFePagamento;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.modelo.SatCFeXmlCancelamento;
import br.com.maximasolutions.sat.repository.SatCFeItemRepository;
import br.com.maximasolutions.sat.repository.SatCFePagamentoRepository;
import br.com.maximasolutions.sat.repository.SatCFeRepository;
import br.com.maximasolutions.sat.repository.SatCFeXmlCancelamentoRepository;
import br.com.maximasolutions.sat.repository.SatCFeXmlRepository;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.util.SatUtils;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.sat.xml.modelo.CFeImpressao;
import br.com.maximasolutions.sat.xml.modelo.DetalhamentoProdutosCFe;
import br.com.maximasolutions.sat.xml.modelo.InformacoesCOFINS;
import br.com.maximasolutions.sat.xml.modelo.InformacoesICMS;
import br.com.maximasolutions.sat.xml.modelo.InformacoesPIS;
import br.com.maximasolutions.sat.xml.modelo.MP;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SatCFeServiceImpl
implements SatCFeService {
    @Autowired
    private SatCFeRepository satCFeRepository;
    @Autowired
    private SatCFeItemRepository satCFeItemRepository;
    @Autowired
    private SatCFePagamentoRepository satCFePagamentoRepository;
    @Autowired
    private SatCFeXmlRepository satCFeXmlRepository;
    @Autowired
    private SatCFeXmlCancelamentoRepository satCFeXmlCancelamentoRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private ProdutoService produtoService;

    @Transactional(readOnly=true)
    public SatCFe load(Long id) {
        return (SatCFe)this.satCFeRepository.getOne((Object)id);
    }

    public SatCFeXml loadXml(long satCfeId) {
        SatCFe cupom = (SatCFe)this.satCFeRepository.getOne((Object)satCfeId);
        return cupom.getXml();
    }

    @Transactional(readOnly=true)
    public SatCFe getUltimo() {
        Page ultimo = this.satCFeRepository.getUltimoCupom(0L, (Pageable)PageRequest.of((int)0, (int)1));
        if (ultimo.isEmpty()) {
            return null;
        }
        return (SatCFe)ultimo.getContent().get(0);
    }

    public SatCFe salvaCupom(SatCFe satCFe, List<SatCFeItem> itens, List<SatCFePagamento> parcelas, SatCFeXml satCFeXml, VendaProduto vendaProduto) {
        if (vendaProduto != null) {
            satCFe.setMovimentoCaixa(vendaProduto.getMovimentoCaixa());
            satCFe.setNumeroSerie(vendaProduto.getMovimentoCaixa().getCaixa().getNumeroSerieSat());
        }
        satCFe = (SatCFe)this.satCFeRepository.save((Object)satCFe);
        for (SatCFeItem i : itens) {
            i.setCfe(satCFe);
            this.satCFeItemRepository.save((Object)i);
        }
        for (SatCFePagamento p : parcelas) {
            p.setCfe(satCFe);
            this.satCFePagamentoRepository.save((Object)p);
        }
        satCFeXml.setCfe(satCFe);
        this.satCFeXmlRepository.save((Object)satCFeXml);
        if (vendaProduto != null) {
            vendaProduto.setSatCFe(satCFe);
            this.vendaProdutoRepository.save((Object)vendaProduto);
        }
        return satCFe;
    }

    public SatCFe cancelaCupom(SatCFe satCFe, byte[] xmlCancelamento) {
        satCFe.setCancelado(Boolean.TRUE);
        satCFe = (SatCFe)this.satCFeRepository.save((Object)satCFe);
        SatCFeXmlCancelamento xml = new SatCFeXmlCancelamento();
        xml.setArquivo(xmlCancelamento);
        xml.setCfe(satCFe);
        this.satCFeXmlCancelamentoRepository.save((Object)xml);
        return satCFe;
    }

    @Transactional(readOnly=true)
    public SatCFe getSatCfeXmlCupom(CFe xmlCFe) {
        SatCFe cupomCFe = new SatCFe();
        cupomCFe.setDataEmissao(SatUtils.dateStringToLocalDate((String)xmlCFe.getInfCFe().getIde().getdEmi()));
        cupomCFe.setChaveAssinada(xmlCFe.getInfCFe().getIde().getSignAC());
        cupomCFe.setCnpjSoftwareHouse(xmlCFe.getInfCFe().getIde().getCNPJ());
        cupomCFe.setCnpjEmitente(xmlCFe.getInfCFe().getEmit().getCNPJ());
        cupomCFe.setHoraEmissao(xmlCFe.getInfCFe().getIde().gethEmi());
        cupomCFe.setIeEmitente(xmlCFe.getInfCFe().getEmit().getIE());
        cupomCFe.setNumeroCaixa(xmlCFe.getInfCFe().getIde().getNumeroCaixa());
        cupomCFe.setChaveAcesso(xmlCFe.getInfCFe().getId().replace("CFe", ""));
        cupomCFe.setValorProdutos(new BigDecimal(xmlCFe.getInfCFe().getTotal().getICMSTot().getValorProdutos()));
        cupomCFe.setTotal(new BigDecimal(xmlCFe.getInfCFe().getTotal().getValorCupom()));
        cupomCFe.setNumeroCupom(xmlCFe.getInfCFe().getIde().getnCFe().trim());
        cupomCFe.setNomeConsumidor(xmlCFe.getInfCFe().getDest().getxNome());
        if (xmlCFe.getInfCFe().getDest().getCNPJ() != null) {
            cupomCFe.setCpfCnpjDest(xmlCFe.getInfCFe().getDest().getCNPJ());
        }
        if (xmlCFe.getInfCFe().getDest().getCPF() != null) {
            cupomCFe.setCpfCnpjDest(xmlCFe.getInfCFe().getDest().getCPF());
        }
        return cupomCFe;
    }

    @Transactional(readOnly=true)
    public List<SatCFeItem> getSatCfeItemXmlCupom(CFe xmlCFe) {
        ArrayList<SatCFeItem> listRetorno = new ArrayList<SatCFeItem>();
        for (DetalhamentoProdutosCFe i : xmlCFe.getInfCFe().getDet()) {
            SatCFeItem item = new SatCFeItem();
            item.setCfop(i.getProd().getCFOP());
            item.setCodigo(i.getProd().getcProd());
            item.setDescricao(i.getProd().getxProd());
            item.setEan13("");
            item.setNcm(i.getProd().getNCM());
            item.setNumeroItem(i.getNItem());
            item.setProduto(this.produtoService.getByCodigoBarras(item.getCodigo()));
            item.setQuantidade(new BigDecimal(i.getProd().getqCom()));
            item.setUnidade(i.getProd().getuCom());
            if (i.getProd().getvDesc() != null) {
                item.setDesconto(new BigDecimal(i.getProd().getvDesc()));
            } else {
                item.setDesconto(BigDecimal.ZERO);
            }
            item.setValorUnitario(new BigDecimal(i.getProd().getvUnCom()));
            item.setValorProdutos(new BigDecimal(i.getProd().getvProd()));
            item.setValorTotalItem(new BigDecimal(i.getProd().getvItem()));
            item.setPis(SatEnviaController.getPis((InformacoesPIS)i.getImposto().getPIS()));
            item.setCofins(SatEnviaController.getCofins((InformacoesCOFINS)i.getImposto().getCOFINS()));
            item.setOrigem(SatEnviaController.getOrigem((InformacoesICMS)i.getImposto().getICMS()));
            item.setCson(SatEnviaController.getCsosn((InformacoesICMS)i.getImposto().getICMS()));
            listRetorno.add(item);
        }
        return listRetorno;
    }

    @Transactional(readOnly=true)
    public List<SatCFePagamento> getSatCfePagamento(CFe xmlCFe) {
        ArrayList<SatCFePagamento> listRetorno = new ArrayList<SatCFePagamento>();
        for (MP i : xmlCFe.getInfCFe().getPgto().getMp()) {
            SatCFePagamento parc = new SatCFePagamento();
            parc.setValor(new BigDecimal(i.getvMP()));
            parc.setFormaPagamento(FormaPagamento.valueOfCodigoSat((String)i.getcMP()));
            listRetorno.add(parc);
        }
        return listRetorno;
    }

    @Transactional(readOnly=true)
    public List<SatCFe> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.satCFeRepository.lista(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public void exporta(LocalDate inicio, LocalDate fim, String path) throws MaximaValidacaoException {
        File caminhoRaiz;
        if (!path.endsWith("/") || !path.endsWith("\\")) {
            path = path + "/";
        }
        if (!(caminhoRaiz = new File(path)).exists()) {
            caminhoRaiz.mkdir();
        }
        List cupons = this.satCFeRepository.lista(inicio, fim);
        System.out.println("*** Total de Cupons: " + cupons.size());
        for (SatCFe cupom : cupons) {
            String caminhoCupom = path + cupom.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File pathCupomBck = new File(caminhoCupom);
            if (!pathCupomBck.exists()) {
                pathCupomBck.mkdir();
            }
            String nome = cupom.getChaveAcesso() + ".xml";
            ControleArquivos.escreverBytesArquivo((String)(caminhoCupom + nome), (byte[])cupom.getXml().getArquivo());
            System.out.println(caminhoCupom + nome);
        }
    }

    @Transactional(readOnly=true)
    public List<SatCFeItem> relatorioItens(LocalDate inicio, LocalDate fim, Boolean agruparProdutos) {
        return this.satCFeItemRepository.listaPorPeriodo(inicio, fim);
    }

    @Transactional(readOnly=true)
    public List<RelatorioFiscalProdutoBean> relatorioItensBean(LocalDate inicio, LocalDate fim, Boolean agruparProdutos) {
        List lista = agruparProdutos != false ? this.satCFeItemRepository.listaPorPeriodoAgrupado(inicio, fim) : this.satCFeItemRepository.listaPorPeriodoBean(inicio, fim);
        ArrayList<RelatorioFiscalProdutoBean> retorno = new ArrayList<RelatorioFiscalProdutoBean>();
        for (Object[] obj : lista) {
            RelatorioFiscalProdutoBean bean = new RelatorioFiscalProdutoBean();
            bean.setProduto((String)obj[0]);
            bean.setQuantidade(new BigDecimal(obj[1].toString()));
            bean.setCusto(new BigDecimal(obj[2].toString()));
            bean.setTotal(new BigDecimal(obj[3].toString()));
            if (!agruparProdutos.booleanValue()) {
                LocalDate dataEmissao = (LocalDate)obj[4];
                bean.setData(dataEmissao.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
                bean.setNota((String)obj[5]);
            } else {
                bean.setData("---");
                bean.setNota("---");
            }
            retorno.add(bean);
        }
        return retorno;
    }

    public List<RelatorioFiscalDto> relatorioFiscalAgrupado(LocalDate inicio, LocalDate fim) {
        List lista = this.satCFeItemRepository.listaPorPeriodoAgrupado(inicio, fim);
        ArrayList<RelatorioFiscalDto> retorno = new ArrayList<RelatorioFiscalDto>();
        for (Object[] obj : lista) {
            RelatorioFiscalDto bean = new RelatorioFiscalDto();
            bean.setCodigo((String)obj[6]);
            bean.setProduto((String)obj[0]);
            bean.setQuantidade(new BigDecimal(obj[1].toString()));
            bean.setValorMedio(new BigDecimal(obj[2].toString()));
            bean.setTotal(new BigDecimal(obj[3].toString()));
            bean.setCst((String)obj[7]);
            bean.setCategoriaNome((String)obj[8]);
            retorno.add(bean);
        }
        return retorno;
    }

    public SatCFe importa(CFeImpressao cfe, String xml) {
        SatCFe cupom = new SatCFe();
        cupom.setAvulso(Boolean.valueOf(true));
        cupom.setCancelado(Boolean.valueOf(false));
        cupom.setChaveAcesso(cfe.getInfCFe().getId());
        String destinatario = MaximaUtils.formatCPF((String)cfe.getInfCFe().getDest().getCPF());
        if (destinatario == null) {
            destinatario = MaximaUtils.formatCNPJ((String)cfe.getInfCFe().getDest().getCNPJ());
        }
        String nomeConsumidor = null;
        if (destinatario != null) {
            nomeConsumidor = cfe.getInfCFe().getDest().getxNome();
        }
        cupom.setCpfCnpjDest(destinatario);
        cupom.setNomeConsumidor(nomeConsumidor);
        String data = cfe.getInfCFe().getIde().getdEmi();
        String hora = cfe.getInfCFe().getIde().gethEmi();
        data = data.substring(6, 8) + "/" + data.substring(4, 6) + "/" + data.substring(0, 4);
        hora = hora.substring(0, 2) + ":" + hora.substring(2, 4) + ":" + hora.substring(4);
        cupom.setDataEmissao(MaximaDate.convertToLocalDate((String)data));
        cupom.setHoraEmissao(hora);
        cupom.setNumeroSerie(cfe.getInfCFe().getIde().getNserieSAT());
        cupom.setNumeroCupom(cfe.getInfCFe().getIde().getnCFe());
        cupom.setTotal(new BigDecimal(cfe.getInfCFe().getTotal().getValorCupom()));
        cupom = (SatCFe)this.satCFeRepository.save((Object)cupom);
        SatCFeXml satXml = new SatCFeXml();
        satXml.setArquivo(xml.getBytes());
        satXml.setCfe(cupom);
        this.satCFeXmlRepository.save((Object)satXml);
        return cupom;
    }
}

