/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sped;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.modelo.EntradaCTe;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Empresa;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.swconsultoria.efd.icms.registros.bloco0.Bloco0;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0000;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0001;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0005;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0100;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0150;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0190;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0200;
import br.com.swconsultoria.efd.icms.registros.bloco0.Registro0450;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpedBloco0 {
    public static Bloco0 preencheBloco0(Configuracao conf, LocalDate dataInicial, LocalDate dataFinal, List<Fornecedor> fornecedores, List<Cliente> clientes, List<String> unidades, List<MateriaPrima> materiaPrimaLista, List<Produto> produtoLista, List<EntradaCTe> emitentesCTe) {
        Bloco0 bloco0 = new Bloco0();
        bloco0 = SpedBloco0.preencheRegistro0000((Bloco0)bloco0, (Empresa)conf.getEmpresaNFe(), (LocalDate)dataInicial, (LocalDate)dataFinal);
        bloco0 = SpedBloco0.preencheRegistro0001((Bloco0)bloco0);
        bloco0 = SpedBloco0.preencheRegistro0005((Bloco0)bloco0, (Empresa)conf.getEmpresaNFe());
        bloco0 = SpedBloco0.preencheRegistro0100((Bloco0)bloco0, (Contador)conf.getContador());
        bloco0 = SpedBloco0.preencheRegistro0150((Bloco0)bloco0, fornecedores, clientes, emitentesCTe);
        bloco0 = SpedBloco0.preencheRegistro0190((Bloco0)bloco0, unidades);
        bloco0 = SpedBloco0.preencheRegistro0200((Bloco0)bloco0, materiaPrimaLista, produtoLista);
        return bloco0;
    }

    public static Bloco0 preencheRegistro0000(Bloco0 bloco0, Empresa empresa, LocalDate dataInicial, LocalDate dataFinal) {
        Registro0000 registro0000 = new Registro0000();
        registro0000.setCod_fin("0");
        registro0000.setDt_ini(dataInicial.format(DateTimeFormatter.ofPattern("ddMMyyyy")));
        registro0000.setDt_fin(dataFinal.format(DateTimeFormatter.ofPattern("ddMMyyyy")));
        registro0000.setNome(MaximaUtils.getText((String)empresa.getNome()));
        registro0000.setCnpj(MaximaUtils.removeCaracteres((String)empresa.getCpf()));
        registro0000.setUf(empresa.getMunicipio().getEstado().getSigla());
        registro0000.setIe(MaximaUtils.removeCaracteres((String)empresa.getRg()));
        registro0000.setCod_mun(empresa.getMunicipio().getCodigoIBGE());
        registro0000.setInd_perfil("A");
        registro0000.setInd_ativ("1");
        bloco0.setRegistro0000(registro0000);
        return bloco0;
    }

    public static Bloco0 preencheRegistro0001(Bloco0 bloco0) {
        Registro0001 registro0001 = new Registro0001();
        registro0001.setInd_mov("0");
        bloco0.setRegistro0001(registro0001);
        return bloco0;
    }

    public static Bloco0 preencheRegistro0005(Bloco0 bloco0, Empresa empresa) {
        Registro0005 registro0005 = new Registro0005();
        registro0005.setFantasia(MaximaUtils.getText((String)empresa.getFantasia()));
        registro0005.setCep(MaximaUtils.removeAcentos((String)empresa.getCep()));
        registro0005.setEnd(MaximaUtils.getText((String)empresa.getEndereco()));
        registro0005.setNum(MaximaUtils.getText((String)empresa.getNumero()));
        registro0005.setCompl("");
        registro0005.setBairro(MaximaUtils.getText((String)empresa.getBairro()));
        registro0005.setFone(MaximaUtils.removeCaracteres((String)empresa.getTelefone()));
        registro0005.setEmail(MaximaUtils.getText((String)empresa.getEmail()));
        bloco0.setRegistro0005(registro0005);
        return bloco0;
    }

    public static Bloco0 preencheRegistro0100(Bloco0 bloco0, Contador contador) {
        Registro0100 registro0100 = new Registro0100();
        registro0100.setNome(MaximaUtils.getText((String)contador.getNome()));
        registro0100.setCpf(MaximaUtils.removeCaracteres((String)contador.getCpf()));
        registro0100.setCrc(MaximaUtils.removeCaracteres((String)contador.getCrc()));
        registro0100.setCep(MaximaUtils.removeCaracteres((String)contador.getCep()));
        registro0100.setEnd(MaximaUtils.getText((String)contador.getEndereco()));
        registro0100.setNum(MaximaUtils.getText((String)contador.getNumero()));
        registro0100.setBairro(MaximaUtils.getText((String)contador.getBairro()));
        registro0100.setFone(MaximaUtils.removeCaracteres((String)contador.getTelefone()));
        registro0100.setEmail(MaximaUtils.getText((String)contador.getEmail()));
        registro0100.setCod_mun(contador.getMunicipio().getCodigoIBGE());
        bloco0.setRegistro0100(registro0100);
        return bloco0;
    }

    public static Bloco0 preencheRegistro0150(Bloco0 bloco0, List<Fornecedor> fornecedores, List<Cliente> clientes, List<EntradaCTe> emitentesCTe) {
        fornecedores.stream().map(forn -> {
            Registro0150 registro0150 = new Registro0150();
            registro0150.setCod_part(MaximaUtils.removeCaracteres((String)forn.getCpf()));
            registro0150.setNome(MaximaUtils.getText((String)forn.getNome()));
            registro0150.setCod_pais("1058");
            registro0150.setCnpj(MaximaUtils.removeCaracteres((String)forn.getCpf()));
            if (forn.getRg() != null && !forn.getRg().equalsIgnoreCase("ISENTO")) {
                registro0150.setIe(MaximaUtils.removeCaracteres((String)forn.getRg()));
            }
            registro0150.setCod_mun(forn.getMunicipio().getCodigoIBGE());
            registro0150.setEnd(MaximaUtils.getText((String)forn.getEndereco()));
            registro0150.setNum(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)forn.getNumero()), (int)10));
            registro0150.setCompl(MaximaUtils.getText((String)forn.getComplemento()));
            registro0150.setBairro(MaximaUtils.getText((String)forn.getBairro()));
            return registro0150;
        }).forEachOrdered(registro0150 -> bloco0.getRegistro0150().add(registro0150));
        clientes.stream().map(cli -> {
            Registro0150 registro0150 = new Registro0150();
            registro0150.setCod_part(MaximaUtils.removeCaracteres((String)cli.getCpf()));
            registro0150.setNome(MaximaUtils.getText((String)cli.getNome()));
            registro0150.setCod_pais("1058");
            String cnpjCpf = MaximaUtils.removeCaracteres((String)cli.getCpf());
            if (cnpjCpf.length() > 11) {
                registro0150.setCnpj(cnpjCpf);
                if (cli.getRg() != null && cli.getRg().equalsIgnoreCase("ISENTO")) {
                    registro0150.setIe("");
                } else {
                    registro0150.setIe(MaximaUtils.removeCaracteres((String)cli.getRg()));
                }
            } else {
                registro0150.setCpf(cnpjCpf);
            }
            registro0150.setCod_mun(cli.getMunicipio().getCodigoIBGE());
            registro0150.setEnd(MaximaUtils.getText((String)cli.getEndereco()));
            registro0150.setNum(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)cli.getNumero()), (int)10));
            registro0150.setCompl(MaximaUtils.getText((String)cli.getComplemento()));
            registro0150.setBairro(MaximaUtils.getText((String)cli.getBairro()));
            return registro0150;
        }).forEachOrdered(registro0150 -> bloco0.getRegistro0150().add(registro0150));
        emitentesCTe.stream().map(cte -> {
            Registro0150 registro0150 = new Registro0150();
            registro0150.setCod_part(MaximaUtils.removeCaracteres((String)cte.getEmitenteCnpj()));
            registro0150.setNome(MaximaUtils.getText((String)cte.getEmitente()));
            registro0150.setCod_pais("1058");
            String cnpjCpf = MaximaUtils.removeCaracteres((String)cte.getEmitenteCnpj());
            if (cnpjCpf.length() > 11) {
                registro0150.setCnpj(cnpjCpf);
                registro0150.setIe(MaximaUtils.removeCaracteres((String)cte.getEmitenteIE()));
            } else {
                registro0150.setCpf(cnpjCpf);
            }
            registro0150.setCod_mun(cte.getEmitenteCodigoIBGE().toString());
            registro0150.setEnd(MaximaUtils.getText((String)cte.getEmitenteEndereco()));
            registro0150.setNum(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)cte.getEmitenteNumero()), (int)10));
            registro0150.setCompl(MaximaUtils.getText((String)cte.getEmitenteComplemento()));
            registro0150.setBairro(MaximaUtils.getText((String)cte.getEmitenteBairro()));
            return registro0150;
        }).forEachOrdered(registro0150 -> bloco0.getRegistro0150().add(registro0150));
        return bloco0;
    }

    public static Bloco0 preencheRegistro0190(Bloco0 bloco0, List<String> unidades) {
        unidades.stream().map(un -> {
            Registro0190 registro0190 = new Registro0190();
            registro0190.setUnid(un);
            registro0190.setDescr(un);
            return registro0190;
        }).forEachOrdered(registro0190 -> bloco0.getRegistro0190().add(registro0190));
        return bloco0;
    }

    public static Bloco0 preencheRegistro0200(Bloco0 bloco0, List<MateriaPrima> materiaPrimaLista, List<Produto> produtoLista) {
        materiaPrimaLista.stream().map(mp -> {
            Registro0200 registro0200 = new Registro0200();
            registro0200.setCod_item(mp.getId().toString());
            registro0200.setDescr_item(MaximaUtils.getText((String)mp.getNome()));
            registro0200.setUnid_inv(mp.getUnidade().getSigla());
            registro0200.setTipo_item("01");
            registro0200.setCod_ncm(MaximaUtils.getText((String)mp.getNcm()));
            return registro0200;
        }).forEachOrdered(registro0200 -> bloco0.getRegistro0200().add(registro0200));
        produtoLista.stream().map(prod -> {
            Registro0200 registro0200 = new Registro0200();
            registro0200.setCod_item("P" + prod.getId().toString());
            registro0200.setDescr_item(MaximaUtils.getText((String)prod.getNome()));
            registro0200.setUnid_inv(prod.getUnidade().getSigla());
            registro0200.setTipo_item("01");
            registro0200.setCod_ncm(MaximaUtils.getText((String)prod.getNcm()));
            registro0200.setAliq_icms(MaximaNumber.formataNumeroSped((BigDecimal)prod.getAliquotaICMS()));
            return registro0200;
        }).forEachOrdered(registro0200 -> bloco0.getRegistro0200().add(registro0200));
        return bloco0;
    }

    public static Bloco0 preencheRegistro0450(Bloco0 bloco0) {
        Registro0450 registro0450 = new Registro0450();
        registro0450.setCod_inf("1");
        registro0450.setTxt("Relacao ECF(S):");
        bloco0.getRegistro0450().add(registro0450);
        return bloco0;
    }
}

