/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.vendasexternas.controller.ClienteVendaExternaFormController;
import br.com.maximasolutions.vendasexternas.modelo.ClienteVendaExterna;
import br.com.maximasolutions.vendasexternas.service.ClienteVendaExternaService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ClienteVendaExternaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<ClienteVendaExterna> tabela;
    @FXML
    private TableColumn<ClienteVendaExterna, String> colNome;
    @FXML
    private TableColumn<ClienteVendaExterna, String> colCPF;
    @FXML
    private TableColumn<ClienteVendaExterna, String> colCidade;
    @Autowired
    private ClienteVendaExternaService clienteVendaExternaService;
    private ObservableList<ClienteVendaExterna> clienteVendaExternaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.clienteVendaExternaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.confirma();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void confirma() {
        ClienteVendaExterna clienteVendaExterna = (ClienteVendaExterna)this.tabela.getSelectionModel().getSelectedItem();
        if (clienteVendaExterna == null) {
            MaximaAlert.alerta((String)"Selecione um cliente para confirmar cadastro.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/vendasExternas/cliente/ClienteForm.fxml", "Cliente Venda Externa");
            ClienteVendaExternaFormController controller = (ClienteVendaExternaFormController)stage.getUserData();
            controller.inicializa(clienteVendaExterna);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ClienteVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form clienteVendaExterna.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void deleteClienteVendaExterna() {
        ClienteVendaExterna clienteVendaExterna = (ClienteVendaExterna)this.tabela.getSelectionModel().getSelectedItem();
        if (clienteVendaExterna == null) {
            MaximaAlert.alerta((String)"Selecione um clienteVendaExterna para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover o clienteVendaExterna: '" + clienteVendaExterna.getNome() + "'?"))) {
            try {
                this.clienteVendaExternaService.deleteById(clienteVendaExterna.getId());
                MaximaAlert.confirmacao((String)"ClienteVendaExterna deletado com sucesso.");
            }
            catch (MaximaException ex) {
                Logger.getLogger(ClienteVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.alerta((String)("Erro: N\u00e3o foi poss\u00edvel remover o cliente.\nCausa:" + ex.getMessage()));
            }
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.clienteVendaExternaList.clear();
        this.clienteVendaExternaList.addAll((Collection)this.clienteVendaExternaService.list());
        this.tabela.setItems(this.clienteVendaExternaList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colCPF.setCellValueFactory((Callback)new PropertyValueFactory("cpfCnpj"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("cidade"));
    }

    private void registraAcoes() {
        this.btnEdita.setOnAction(event -> this.confirma());
        this.btnDelete.setOnAction(event -> this.deleteClienteVendaExterna());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

