/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.vendasexternas.controller.PedidoVendaExternaFormController;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.service.PedidoVendaExternaService;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoVendaExternaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnConfirma;
    @FXML
    private TableView<PedidoVendaExterna> tabela;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colId;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colData;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colVendedor;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colCliente;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colValorTotal;
    @FXML
    private TableColumn<PedidoVendaExterna, String> colStatus;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @FXML
    private CheckBox ccbConfirmado;
    @FXML
    private CheckBox ccbExcluido;
    @Autowired
    private PedidoVendaExternaService pedidoVendaExternaService;
    private ObservableList<PedidoVendaExterna> pedidoVendaExternaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)LocalDate.now());
        this.carregaIcones();
        this.pedidoVendaExternaList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void confirmaPedido() {
        PedidoVendaExterna pedidoVendaExterna = (PedidoVendaExterna)this.tabela.getSelectionModel().getSelectedItem();
        if (pedidoVendaExterna == null) {
            MaximaAlert.alerta((String)"Selecione um pedido para validar.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/vendasExternas/pedido/PedidoVendaExternaForm.fxml", "Confirma\u00e7\u00e3o de pedido de venda");
            PedidoVendaExternaFormController controller = (PedidoVendaExternaFormController)stage.getUserData();
            controller.inicializa(pedidoVendaExterna);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)"Erro: M\u00f3dulo de confirma\u00e7\u00e3 de pedido de venda n\u00e3o carregado.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.pedidoVendaExternaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        this.pedidoVendaExternaList.addAll((Collection)this.pedidoVendaExternaService.lista(inicio, fim, Boolean.valueOf(this.ccbConfirmado.isSelected()), Boolean.valueOf(this.ccbExcluido.isSelected()), filtro));
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)this.pedidoVendaExternaService.totalLista(inicio, fim, Boolean.valueOf(this.ccbConfirmado.isSelected()), Boolean.valueOf(this.ccbExcluido.isSelected()), filtro), (int)2));
        this.tabela.setItems(this.pedidoVendaExternaList);
    }

    private void carregaIcones() {
        this.btnConfirma.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataPedido"));
        this.colVendedor.setCellValueFactory((Callback)new PropertyValueFactory("vendedor"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colValorTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValorTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnConfirma.setOnAction(event -> this.confirmaPedido());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.confirmaPedido();
            }
        });
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

