/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.vendasexternas.controller.PedidoVendaExternaController;
import br.com.maximasolutions.vendasexternas.modelo.PedidoItemVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.service.PedidoVendaExternaService;
import java.math.BigDecimal;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoVendaExternaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfVendedorDescricao;
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfDataPedido;
    @FXML
    private TextField tfCondicaoPagamento;
    @FXML
    private TableView<PedidoItemVendaExterna> tabela;
    @FXML
    private TableColumn<PedidoItemVendaExterna, String> colCodigo;
    @FXML
    private TableColumn<PedidoItemVendaExterna, String> colProduto;
    @FXML
    private TableColumn<PedidoItemVendaExterna, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItemVendaExterna, BigDecimal> colPrecoUnitario;
    @FXML
    private TableColumn<PedidoItemVendaExterna, BigDecimal> colPrecoTotal;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnRejeitar;
    @FXML
    private Button btnExcluir;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private PedidoVendaExternaService pedidoVendaExternaService;
    @Autowired
    private CondicaoRecebimentoService condicaoPagamentoService;
    private PedidoVendaExterna pedidoVendaExterna;
    private ObservableList<PedidoItemVendaExterna> vendedorProdutoLancamentoItemList;

    public void initialize(URL url, ResourceBundle rb) {
        this.vendedorProdutoLancamentoItemList = FXCollections.observableArrayList();
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.setColumnProperties();
    }

    private void salva() {
        try {
            this.pedidoVendaExternaService.confirma(this.pedidoVendaExterna);
            MaximaAlert.mensagemInformativa((String)"Pedido confirmado com sucesso");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Aviso: " + ex.getMessage()));
        }
    }

    private void rejeita() {
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Tem certeza que deseja rejeitar o pedido?")) {
            return;
        }
        try {
            this.pedidoVendaExternaService.rejeita(this.pedidoVendaExterna);
            MaximaAlert.mensagemInformativa((String)"Pedido rejeitado com sucesso");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Aviso: " + ex.getMessage()));
        }
    }

    private void exclui() {
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Tem certeza que deseja rejeitar o pedido?")) {
            return;
        }
        try {
            this.pedidoVendaExternaService.exclui(this.pedidoVendaExterna);
            MaximaAlert.mensagemInformativa((String)"Pedido exclu\u00eddo com sucesso");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Aviso: " + ex.getMessage()));
        }
    }

    public void inicializa(PedidoVendaExterna pedido1) {
        this.pedidoVendaExterna = pedido1;
        this.carregaDados();
    }

    private void carregaDados() {
        if (this.pedidoVendaExterna.getConfirmado().booleanValue()) {
            this.btnSalva.setDisable(true);
            this.btnRejeitar.setDisable(true);
        }
        this.tfClienteDescricao.setText(this.pedidoVendaExterna.getCliente().getId() + " - " + this.pedidoVendaExterna.getCliente().getNome());
        this.tfVendedorDescricao.setText(this.pedidoVendaExterna.getVendedor().getId() + " - " + this.pedidoVendaExterna.getVendedor().getNome().toUpperCase());
        this.tfDataPedido.setText(this.pedidoVendaExterna.getDataPedido().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        this.tfObservacao.setText(this.pedidoVendaExterna.getObservacao());
        this.tfCondicaoPagamento.setText(this.condicaoPagamentoService.load(this.pedidoVendaExterna.getPagamentoId().longValue()).getNome().toUpperCase());
        this.loadTabela();
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnRejeitar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void loadTabela() {
        this.vendedorProdutoLancamentoItemList.clear();
        this.vendedorProdutoLancamentoItemList.addAll((Collection)this.pedidoVendaExternaService.itens(this.pedidoVendaExterna));
        this.tabela.setItems(this.vendedorProdutoLancamentoItemList);
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colPrecoUnitario.setCellValueFactory((Callback)new PropertyValueFactory("valorUnitario"));
        this.colPrecoTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnRejeitar.setOnAction(event -> this.rejeita());
        this.btnExcluir.setOnAction(event -> this.exclui());
    }
}

