/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoLancamento;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoLancamentoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendedorProdutoLancamentoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<VendedorProdutoLancamento> tabela;
    @FXML
    private TableColumn<VendedorProdutoLancamento, String> colData;
    @FXML
    private TableColumn<VendedorProdutoLancamento, String> colVendedor;
    @FXML
    private TableColumn<VendedorProdutoLancamento, String> colValorTotal;
    @Autowired
    private VendedorProdutoLancamentoService vendedorProdutoLancamentoService;
    private ObservableList<VendedorProdutoLancamento> vendedorProdutoLancamentoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendedorProdutoLancamentoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaVendedorProdutoLancamento();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void novoVendedorProdutoLancamento() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/vendasExternas/vendedorProduto/VendedorProdutoLancamentoForm.fxml", "Novo Lan\u00e7amento");
            VendedorProdutoLancamentoFormController controller = (VendedorProdutoLancamentoFormController)stage.getUserData();
            controller.inicializa(null);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form vendedorProdutoLancamento.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void editaVendedorProdutoLancamento() {
    }

    private void deleteVendedorProdutoLancamento() {
        VendedorProdutoLancamento vendedorProdutoLancamento = (VendedorProdutoLancamento)this.tabela.getSelectionModel().getSelectedItem();
        if (vendedorProdutoLancamento == null) {
            MaximaAlert.alerta((String)"Selecione um vendedorProdutoLancamento para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover o lan\u00e7amento para o vendedor: '" + vendedorProdutoLancamento.getVendedor().getNome() + "'?"))) {
            this.vendedorProdutoLancamentoService.delete(vendedorProdutoLancamento);
            MaximaAlert.confirmacao((String)"Lan\u00e7amento deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.vendedorProdutoLancamentoList.clear();
        this.vendedorProdutoLancamentoList.addAll((Collection)this.vendedorProdutoLancamentoService.list());
        this.tabela.setItems(this.vendedorProdutoLancamentoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataLancamento"));
        this.colVendedor.setCellValueFactory((Callback)new PropertyValueFactory("vendedor"));
        this.colValorTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        this.colValorTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoVendedorProdutoLancamento());
        this.btnEdita.setOnAction(event -> this.editaVendedorProdutoLancamento());
        this.btnDelete.setOnAction(event -> this.deleteVendedorProdutoLancamento());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

