/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.converter;

import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaDto;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaItemDto;
import br.com.maximasolutions.vendasexternas.modelo.PedidoItemVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExternaStatus;

public class PedidoVendaExternaConverter {
    public PedidoVendaExterna converter(PedidoVendaExternaDto pedidoDto, Cliente cliente, Vendedor vendedor) {
        PedidoVendaExterna pedido = new PedidoVendaExterna();
        pedido.setCliente(cliente);
        pedido.setConfirmado(Boolean.FALSE);
        pedido.setDataPedido(pedidoDto.getDataPedido());
        pedido.setDesconto(pedidoDto.getDesconto());
        pedido.setExcluido(Boolean.FALSE);
        pedido.setObservacao(pedidoDto.getObservacao());
        pedido.setPagamentoId(pedidoDto.getPagamentoId());
        pedido.setStatus(PedidoVendaExternaStatus.AGUARDANDO_CONFIRMACAO);
        pedido.setTipo(pedidoDto.getTipo());
        pedido.setTotal(pedidoDto.getTotal());
        pedido.setUuid(pedidoDto.getUuid());
        pedido.setVendedor(vendedor);
        return pedido;
    }

    public PedidoItemVendaExterna converter(PedidoVendaExternaItemDto itemDto, PedidoVendaExterna pedido, ProdutoRepository produtoRepository) {
        Produto produto = produtoRepository.get(itemDto.getProdutoId().longValue());
        PedidoItemVendaExterna item = new PedidoItemVendaExterna();
        item.setCodigo(itemDto.getCodigo());
        item.setDesconto(itemDto.getDesconto());
        item.setDescricao(itemDto.getDescricao());
        item.setNumero(itemDto.getNumero());
        item.setObservacao(itemDto.getObservacao());
        item.setPedido(pedido);
        item.setPrecoCusto(produto.getUltimoCusto());
        item.setProduto(produto);
        item.setQuantidade(itemDto.getQuantidade());
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()));
        item.setUnidade(itemDto.getUnidade());
        item.setValorTotal(itemDto.getValorTotal());
        item.setValorUnitario(itemDto.getValorUnitario());
        return item;
    }
}

