/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.vendasexternas.bean.VendedorProdutoBean;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProduto;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoService;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import win.zqxu.jrviewer.JRViewerFX;

@Controller
public class RelatorioEstoqueVendedorController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private VendedorProdutoService vendedorProdutoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnVendedor;
    @FXML
    private TextField tfVendedorCodigo;
    @FXML
    private TextField tfVendedorDescricao;
    private Vendedor vendedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.vendedor = null;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Configuracao conf = this.configuracaoService.load();
        List estoqueLista = this.vendedorProdutoService.list(this.vendedor);
        if (estoqueLista == null || estoqueLista.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum registro encontrado para a pesquisa.");
            return;
        }
        ArrayList<VendedorProdutoBean> lista = new ArrayList<VendedorProdutoBean>();
        BigDecimal estoqueTotal = BigDecimal.ZERO;
        BigDecimal valorEstoque = BigDecimal.ZERO;
        for (VendedorProduto vp : estoqueLista) {
            VendedorProdutoBean bean = new VendedorProdutoBean(vp);
            lista.add(bean);
            estoqueTotal = estoqueTotal.add(bean.getEstoque());
            valorEstoque = valorEstoque.add(bean.getTotal());
        }
        try {
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(lista);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("TITULO", "RELAT\u00d3RIO - ESTOQUE POR VENDEDOR");
            if (this.vendedor != null) {
                params.put("VENDEDOR", "VENDEDOR: " + this.vendedor.getNome().toUpperCase());
            }
            params.put("EMPRESA", conf.getNomeEmpresa().toUpperCase());
            params.put("VENDEDOR", this.vendedor.getNome().toUpperCase());
            params.put("QUANTIDADE", new BigDecimal(lista.size()));
            params.put("ITENS", estoqueTotal);
            params.put("TOTAL", valorEstoque);
            JasperPrint print = JasperFillManager.fillReport((InputStream)this.getClass().getResourceAsStream("/jasper/vendasexternas/vendas-externas-estoque.jasper"), params, (JRDataSource)jrds);
            JRViewerFX.preview((Window)this.btnGeraRelatorio.getScene().getWindow(), (JasperPrint)print);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.vendedor == null) {
            this.tfVendedorCodigo.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfVendedorCodigo.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorCodigo.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaVendedorForm();
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorCodigo.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorCodigo.setText(this.vendedor.getId().toString());
            this.tfVendedorDescricao.setText(this.vendedor.getNome().toUpperCase());
        } else {
            this.tfVendedorCodigo.setText("");
            this.tfVendedorDescricao.setText("");
            this.tfVendedorCodigo.requestFocus();
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnVendedor.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.btnVendedor.setOnAction(event -> this.pesquisaVendedorForm());
        this.tfVendedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
    }

    private void loadCombos() {
    }
}

