/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.report.VendaProdutoReport;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.vendasexternas.bean.PedidoVendaExternaBean;
import br.com.maximasolutions.vendasexternas.bean.PedidoVendaExternaCondicaoRecebimentoBean;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import br.com.maximasolutions.vendasexternas.service.PedidoVendaExternaService;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import win.zqxu.jrviewer.JRViewerFX;

@Controller
public class RelatorioVendasExternasController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private PedidoVendaExternaService pedidoVendaExternaService;
    @Autowired
    private VendedorService vendedorService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnVendedor;
    @FXML
    private DatePicker tfDataInicio;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfVendedorCodigo;
    @FXML
    private TextField tfVendedorDescricao;
    private Vendedor vendedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.vendedor = null;
    }

    private void geraRelatorio() {
        LocalDate dataFim;
        if (!this.validaForm()) {
            return;
        }
        LocalDate dataInicio = (LocalDate)this.tfDataInicio.getValue();
        if (dataInicio.isAfter(dataFim = (LocalDate)this.tfDataFinal.getValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser anterior ou igual a data final.");
            return;
        }
        List list = this.pedidoVendaExternaService.lista(dataInicio, dataFim, this.vendedor);
        BigDecimal totalVendido = BigDecimal.ZERO;
        BigDecimal totalComissao = BigDecimal.ZERO;
        ArrayList<PedidoVendaExternaCondicaoRecebimentoBean> recebimentoLista = new ArrayList<PedidoVendaExternaCondicaoRecebimentoBean>();
        for (PedidoVendaExternaBean bean : list) {
            totalVendido = totalVendido.add(bean.getValorTotal());
            totalComissao = totalComissao.add(bean.getComissao());
            boolean existePagamentoId = false;
            for (PedidoVendaExternaCondicaoRecebimentoBean recebimento : recebimentoLista) {
                if (!bean.getPagamentoId().equals(recebimento.getId())) continue;
                recebimento.setValor(recebimento.getValor().add(bean.getValorTotal()));
                existePagamentoId = true;
                break;
            }
            if (existePagamentoId) continue;
            recebimentoLista.add(new PedidoVendaExternaCondicaoRecebimentoBean(bean.getPagamentoId(), bean.getPagamentoDescricao(), bean.getValorTotal()));
        }
        Collections.sort(recebimentoLista);
        BigDecimal quantidadeVendido = new BigDecimal(list.size());
        Configuracao conf = this.configuracaoService.load();
        try {
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)list);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("TITULO", "RELAT\u00d3RIO DE VENDAS EXTERNAS | DE: " + dataInicio.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " AT\u00c9: " + dataFim.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            if (this.vendedor != null) {
                params.put("VENDEDOR", "VENDEDOR: " + this.vendedor.getNome().toUpperCase());
            } else {
                params.put("VENDEDOR", "VENDEDOR: TODOS");
            }
            params.put("EMPRESA", conf.getNomeEmpresa().toUpperCase());
            params.put("TOTAL", totalVendido);
            params.put("COMISSAO", totalComissao);
            params.put("QUANTIDADE", quantidadeVendido);
            params.put("PARCELAS", recebimentoLista);
            URL web = VendaProdutoReport.class.getResource("/jasper/vendasexternas/");
            params.put("subrel", web.toString());
            JasperPrint print = JasperFillManager.fillReport((InputStream)this.getClass().getResourceAsStream("/jasper/vendasexternas/vendas-externas.jasper"), params, (JRDataSource)jrds);
            JRViewerFX.preview((Window)this.btnGeraRelatorio.getScene().getWindow(), (JasperPrint)print);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicio.getValue() == null) {
            this.tfDataInicio.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicio.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorCodigo.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaVendedorForm();
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorCodigo.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorCodigo.setText(this.vendedor.getId().toString());
            this.tfVendedorDescricao.setText(this.vendedor.getNome().toUpperCase());
        } else {
            this.tfVendedorCodigo.setText("");
            this.tfVendedorDescricao.setText("");
            this.tfVendedorCodigo.requestFocus();
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnVendedor.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.btnVendedor.setOnAction(event -> this.pesquisaVendedorForm());
        this.tfVendedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
    }

    private void loadCombos() {
    }
}

