/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.repository;

import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.repository.PedidoVendaExternaRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PedidoVendaExternaRepository
extends JpaRepository<PedidoVendaExterna, Long>,
PedidoVendaExternaRepositoryCustom {
    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.uuid = :uuid")
    public PedidoVendaExterna get(@Param(value="uuid") String var1);

    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.vendaProduto.id = :vendaProdutoId")
    public PedidoVendaExterna getByVenda(@Param(value="vendaProdutoId") Long var1);

    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.excluido = false ORDER BY o.dataPedido DESC, o.id DESC")
    public List<PedidoVendaExterna> list();

    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.confirmado = true AND o.excluido = false AND (o.dataPedido BETWEEN :dataInicio AND :dataFim) ORDER BY o.dataPedido DESC, o.id DESC")
    public List<PedidoVendaExterna> list(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT sum(o.total) FROM PedidoVendaExterna o WHERE o.confirmado = true AND o.excluido = false AND (o.dataPedido BETWEEN :dataInicio AND :dataFim)")
    public BigDecimal total(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT sum(o.totalCusto) FROM PedidoVendaExterna o WHERE o.confirmado = true AND o.excluido = false AND (o.dataPedido BETWEEN :dataInicio AND :dataFim)")
    public BigDecimal totalCusto(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.confirmado = true AND o.excluido = false AND o.vendedor.id = :vendedorId AND (o.dataPedido BETWEEN :dataInicio AND :dataFim) ORDER BY o.dataPedido DESC, o.id DESC")
    public List<PedidoVendaExterna> list(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="vendedorId") Long var3);

    @Modifying
    @Query(value="UPDATE PedidoVendaExterna o SET o.excluido = false WHERE o.excluido is null")
    public void setExcluido();

    @Query(value="SELECT o FROM PedidoVendaExterna o WHERE o.totalCusto is null")
    public List<PedidoVendaExterna> listaCustoNull();
}

