/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe.webservices.distribuicao.WSDistribuicaoNFe;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSCancelamento;
import com.fincatto.documentofiscal.nfe400.webservices.WSCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.webservices.WSConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.WSInutilizacao;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteEnvio;
import com.fincatto.documentofiscal.nfe400.webservices.WSManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSStatusConsulta;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public class WSFacade {
    private final WSLoteEnvio wsLoteEnvio;
    private final WSLoteConsulta wsLoteConsulta;
    private final WSStatusConsulta wsStatusConsulta;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCartaCorrecao wsCartaCorrecao;
    private final WSCancelamento wsCancelamento;
    private final WSConsultaCadastro wsConsultaCadastro;
    private final WSInutilizacao wsInutilizacao;
    private final WSManifestacaoDestinatario wSManifestacaoDestinatario;
    private final WSDistribuicaoNFe wSDistribuicaoNFe;

    public WSFacade(NFeConfig config) throws IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.wsLoteEnvio = new WSLoteEnvio(config);
        this.wsLoteConsulta = new WSLoteConsulta(config);
        this.wsStatusConsulta = new WSStatusConsulta(config);
        this.wsNotaConsulta = new WSNotaConsulta(config);
        this.wsCartaCorrecao = new WSCartaCorrecao(config);
        this.wsCancelamento = new WSCancelamento(config);
        this.wsConsultaCadastro = new WSConsultaCadastro(config);
        this.wsInutilizacao = new WSInutilizacao(config);
        this.wSManifestacaoDestinatario = new WSManifestacaoDestinatario(config);
        this.wSDistribuicaoNFe = new WSDistribuicaoNFe(config);
    }

    public NFLoteEnvioRetorno enviaLoteAssinado(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.wsLoteEnvio.enviaLoteAssinado(loteAssinadoXml, modelo);
    }

    public NFLoteConsultaRetorno consultaLote(String numeroRecibo, DFModelo modelo) throws Exception {
        return this.wsLoteConsulta.consultaLote(numeroRecibo, modelo);
    }

    public NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa uf, DFModelo modelo) throws Exception {
        return this.wsStatusConsulta.consultaStatus(uf, modelo);
    }

    public NFNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        return this.wsNotaConsulta.consultaNota(chaveDeAcesso);
    }

    public NFEnviaEventoRetorno corrigeNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(chave, eventoAssinadoXml);
    }

    public NFEnviaEventoRetorno cancelaNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        NFEnviaEventoRetorno retorno = this.wsCancelamento.cancelaNotaAssinada(chave, eventoAssinadoXml);
        return retorno;
    }

    public NFRetornoEventoInutilizacao inutilizaNotaAssinada(String eventoAssinadoXml, DFModelo modelo) throws Exception {
        return this.wsInutilizacao.inutilizaNotaAssinada(eventoAssinadoXml, modelo);
    }

    public NFRetornoEventoInutilizacao inutilizaNota(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        return this.wsInutilizacao.inutilizaNota(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo);
    }

    public NFRetornoConsultaCadastro consultaCadastro(String cnpj, DFUnidadeFederativa uf) throws Exception {
        return this.wsConsultaCadastro.consultaCadastro(cnpj, uf);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNota(String chave, NFTipoEventoManifestacaoDestinatario tipoEvento, String motivo, String cnpj) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNota(chave, tipoEvento, motivo, cnpj);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNotaAssinada(chave, eventoAssinadoXml);
    }

    public NFDistribuicaoIntRetorno consultarDistribuicaoDFe(String cnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu) throws Exception {
        return this.wSDistribuicaoNFe.consultar(cnpj, uf, chaveAcesso, nsu);
    }

    public NFDistribuicaoIntRetorno consultarDistribuicaoDFe(String cnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu, String ultNsu) throws Exception {
        return this.wSDistribuicaoNFe.consultar(cnpj, uf, chaveAcesso, nsu, ultNsu);
    }
}

